/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.event.EventActor;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.WrappedIngredient;
import dev.ftb.mods.ftbquests.events.CustomTaskEvent;
import dev.ftb.mods.ftbquests.events.ObjectCompletedEvent;
import dev.ftb.mods.ftbquests.events.ObjectStartedEvent;
import dev.ftb.mods.ftbquests.events.QuestProgressEventData;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.integration.FTBQuestsJEIHelper;
import dev.ftb.mods.ftbquests.net.DisplayCompletionToastMessage;
import dev.ftb.mods.ftbquests.net.SubmitTaskMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.CustomTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class Task
extends QuestObject {
    public final Quest quest;

    public Task(Quest q) {
        this.quest = q;
    }

    @Override
    public final QuestObjectType getObjectType() {
        return QuestObjectType.TASK;
    }

    @Override
    public final QuestFile getQuestFile() {
        return this.quest.chapter.file;
    }

    @Override
    public final Chapter getQuestChapter() {
        return this.quest.chapter;
    }

    @Override
    public final long getParentID() {
        return this.quest.id;
    }

    public abstract TaskType getType();

    @Override
    public final int getRelativeProgressFromChildren(TeamData data) {
        long max = this.getMaxProgress();
        if (max <= 0L) {
            return 0;
        }
        long progress = data.getProgress(this);
        if (progress <= 0L) {
            return 0;
        }
        if (progress >= max) {
            return 100;
        }
        return (int)Math.max(1.0, (double)progress * 100.0 / (double)max);
    }

    @Override
    public void onStarted(QuestProgressEventData<?> data) {
        data.teamData.setStarted(this.id, data.time);
        ((EventActor)ObjectStartedEvent.TASK.invoker()).act((Object)new ObjectStartedEvent.TaskEvent(data.withObject(this)));
        this.quest.onStarted(data.withObject(this.quest));
    }

    @Override
    public final void onCompleted(QuestProgressEventData<?> data) {
        data.teamData.setCompleted(this.id, data.time);
        ((EventActor)ObjectCompletedEvent.TASK.invoker()).act((Object)new ObjectCompletedEvent.TaskEvent(data.withObject(this)));
        boolean questCompleted = this.quest.isCompletedRaw(data.teamData);
        if (this.quest.tasks.size() > 1 && !questCompleted && !this.disableToast) {
            new DisplayCompletionToastMessage(this.id).sendTo(data.notifiedPlayers);
        }
        if (questCompleted) {
            this.quest.onCompleted(data.withObject(this.quest));
        }
    }

    public long getMaxProgress() {
        return 1L;
    }

    public String formatMaxProgress() {
        return StringUtils.formatDouble((double)this.getMaxProgress(), (boolean)true);
    }

    public String formatProgress(TeamData teamData, long progress) {
        return StringUtils.formatDouble((double)progress, (boolean)true);
    }

    @Override
    public final void forceProgress(TeamData teamData, ProgressChange progressChange) {
        teamData.setProgress(this, progressChange.reset ? 0L : this.getMaxProgress());
    }

    @Override
    public final void deleteSelf() {
        this.quest.tasks.remove(this);
        for (TeamData data : this.quest.chapter.file.getAllData()) {
            data.resetProgress(this);
        }
        super.deleteSelf();
    }

    @Override
    public final void deleteChildren() {
        for (TeamData data : this.quest.chapter.file.getAllData()) {
            data.resetProgress(this);
        }
        super.deleteChildren();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void editedFromGUI() {
        QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
        if (gui != null) {
            gui.questPanel.refreshWidgets();
            gui.viewQuestPanel.refreshWidgets();
        }
    }

    @Override
    public final void onCreated() {
        this.quest.tasks.add(this);
        if (this instanceof CustomTask && this.quest.chapter.file.isServerSide()) {
            ((EventActor)CustomTaskEvent.EVENT.invoker()).act((Object)new CustomTaskEvent((CustomTask)this));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Component getAltTitle() {
        return this.getType().getDisplayName();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        return this.getType().getIcon();
    }

    @Override
    public final ConfigGroup createSubGroup(ConfigGroup group) {
        TaskType type = this.getType();
        return group.getGroup(this.getObjectType().id).getGroup(type.id.m_135827_()).getGroup(type.id.m_135815_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawGUI(TeamData teamData, PoseStack matrixStack, int x, int y, int w, int h) {
        this.getIcon().draw(matrixStack, x, y, w, h);
    }

    public boolean canInsertItem() {
        return false;
    }

    public boolean consumesResources() {
        return this.canInsertItem();
    }

    public boolean hideProgressNumbers() {
        return this.getMaxProgress() <= 1L;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addMouseOverHeader(TooltipList list, TeamData teamData, boolean advanced) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addMouseOverText(TooltipList list, TeamData teamData) {
        if (this.consumesResources()) {
            list.blankLine();
            list.add((Component)new TranslatableComponent("ftbquests.task.click_to_submit").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addTitleInMouseOverText() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
        if (canClick && this.autoSubmitOnPlayerTick() <= 0) {
            button.playClickSound();
            new SubmitTaskMessage(this.id).sendToServer();
        }
    }

    public boolean submitItemsOnInventoryChange() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Object getIngredient() {
        if (this.addTitleInMouseOverText()) {
            return this.getIcon().getIngredient();
        }
        return new WrappedIngredient(this.getIcon().getIngredient()).tooltip();
    }

    @Override
    public final int refreshJEI() {
        return FTBQuestsJEIHelper.QUESTS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getButtonText() {
        return this.getMaxProgress() > 1L || this.consumesResources() ? new TextComponent(this.formatMaxProgress()) : (MutableComponent)TextComponent.f_131282_;
    }

    public int autoSubmitOnPlayerTick() {
        return 0;
    }

    @Override
    public final boolean cacheProgress() {
        return false;
    }

    public void submitTask(TeamData teamData, ServerPlayer player, ItemStack craftedItem) {
    }

    public final void submitTask(TeamData teamData, ServerPlayer player) {
        this.submitTask(teamData, player, ItemStack.f_41583_);
    }

    public boolean checkOnLogin() {
        return !this.consumesResources();
    }
}

